/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.listener.uddi.api_v2.uddi_org;

import filenet.vw.base.logging.Logger;
import filenet.ws.listener.uddi.api_v2.uddi_org.BusinessKey;
import filenet.ws.listener.uddi.api_v2.uddi_org.BusinessServices;
import filenet.ws.listener.uddi.api_v2.uddi_org.CategoryBag;
import filenet.ws.listener.uddi.api_v2.uddi_org.Contacts;
import filenet.ws.listener.uddi.api_v2.uddi_org.Description;
import filenet.ws.listener.uddi.api_v2.uddi_org.DiscoveryURL;
import filenet.ws.listener.uddi.api_v2.uddi_org.DiscoveryURLs;
import filenet.ws.listener.uddi.api_v2.uddi_org.IdentifierBag;
import filenet.ws.listener.uddi.api_v2.uddi_org.Name;
import filenet.ws.utils.WSConstants;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axis.description.AttributeDesc;
import org.apache.axis.description.ElementDesc;
import org.apache.axis.description.FieldDesc;
import org.apache.axis.description.TypeDesc;
import org.apache.axis.encoding.Deserializer;
import org.apache.axis.encoding.Serializer;
import org.apache.axis.encoding.ser.BeanDeserializer;
import org.apache.axis.encoding.ser.BeanSerializer;
import org.w3c.dom.Element;

public class BusinessEntity
implements Serializable {
    private static final long serialVersionUID = 464L;
    protected Element baseElement = null;
    private DiscoveryURLs discoveryURLs;
    private Name[] name;
    private Description[] description;
    private Contacts contacts;
    private BusinessServices businessServices;
    private IdentifierBag identifierBag;
    private CategoryBag categoryBag;
    private BusinessKey businessKey;
    private String operator;
    private String authorizedName;
    protected static final Logger logger = Logger.getLogger("filenet.ws.listener.uddi");
    protected static final String m_className = "BusinessEntity";
    private Object __equalsCalc = null;
    private boolean __hashCodeCalc = false;
    private static TypeDesc typeDesc = new TypeDesc(BusinessEntity.class);

    public static String _get_FILE_DATE() {
        return "$Date:   29 Jun 2007 01:46:32  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.7  $";
    }

    public BusinessEntity() {
    }

    public BusinessEntity(org.apache.juddi.datatype.business.BusinessEntity uddiBusinessEntity) {
        String keyValue;
        org.apache.juddi.datatype.business.Contacts uddiContacts;
        Vector names = uddiBusinessEntity.getNameVector();
        if (names != null && names.size() > 0) {
            org.apache.juddi.datatype.Name aName = null;
            Object obj = null;
            this.name = new Name[names.size()];
            for (int i = 0; i < names.size(); ++i) {
                obj = names.get(i);
                if (obj == null || !(obj instanceof org.apache.juddi.datatype.Name)) continue;
                aName = obj;
                this.name[i] = new Name(aName);
            }
        }
        this.authorizedName = uddiBusinessEntity.getAuthorizedName();
        this.operator = uddiBusinessEntity.getOperator();
        Vector descriptions = uddiBusinessEntity.getDescriptionVector();
        if (descriptions != null && descriptions.size() > 0) {
            org.apache.juddi.datatype.Description aDescription = null;
            Object obj = null;
            this.description = new Description[descriptions.size()];
            for (int i = 0; i < descriptions.size(); ++i) {
                obj = descriptions.get(i);
                if (obj == null || !(obj instanceof org.apache.juddi.datatype.Description)) continue;
                aDescription = obj;
                this.description[i] = new Description(aDescription);
            }
        }
        if (uddiBusinessEntity.getDiscoveryURLs() != null) {
            this.discoveryURLs = new DiscoveryURLs(uddiBusinessEntity.getDiscoveryURLs());
        }
        if ((uddiContacts = uddiBusinessEntity.getContacts()) != null && uddiContacts.getContactVector().size() > 0) {
            this.contacts = new Contacts(uddiContacts);
        }
        if ((keyValue = uddiBusinessEntity.getBusinessKey()) != null && keyValue.trim().length() > 0) {
            this.businessKey = new BusinessKey(keyValue);
        }
    }

    public void setDiscoveryURLWithBaseURL(String baseURL, String cpName) {
        String m_method = "setDiscoveryURLWithBaseURL";
        if (baseURL != null && this.businessKey != null && this.businessKey.getValue() != null) {
            if (baseURL.endsWith("/")) {
                baseURL = baseURL.substring(0, baseURL.length() - 1);
            }
            StringBuffer buf = new StringBuffer();
            buf.append(baseURL);
            if (cpName != null && cpName.length() > 0) {
                buf.append("/wscp").append(WSConstants.UTF8Encode(cpName));
            }
            buf.append("/uddiv2/discovery");
            buf.append("?").append("businessKey");
            buf.append("=").append(this.businessKey.getValue());
            String url = buf.toString();
            if (logger.isFinest()) {
                logger.finest(m_className, "setDiscoveryURLWithBaseURL", url);
            }
            this.discoveryURLs = new DiscoveryURLs();
            DiscoveryURL[] du = new DiscoveryURL[]{new DiscoveryURL(url)};
            du[0].setUseType("businessEntity");
            this.discoveryURLs.setDiscoveryURL(du);
        }
    }

    public DiscoveryURLs getDiscoveryURLs() {
        return this.discoveryURLs;
    }

    public void setDiscoveryURLs(DiscoveryURLs discoveryURLs) {
        this.discoveryURLs = discoveryURLs;
    }

    public Name[] getName() {
        return this.name;
    }

    public void setName(Name[] name) {
        this.name = name;
    }

    public Name getName(int i) {
        return this.name[i];
    }

    public void setName(int i, Name value) {
        this.name[i] = value;
    }

    public Description[] getDescription() {
        return this.description;
    }

    public void setDescription(Description[] description) {
        this.description = description;
    }

    public Description getDescription(int i) {
        return this.description[i];
    }

    public void setDescription(int i, Description value) {
        this.description[i] = value;
    }

    public Contacts getContacts() {
        return this.contacts;
    }

    public void setContacts(Contacts contacts) {
        this.contacts = contacts;
    }

    public BusinessServices getBusinessServices() {
        return this.businessServices;
    }

    public void setBusinessServices(BusinessServices businessServices) {
        this.businessServices = businessServices;
    }

    public IdentifierBag getIdentifierBag() {
        return this.identifierBag;
    }

    public void setIdentifierBag(IdentifierBag identifierBag) {
        this.identifierBag = identifierBag;
    }

    public CategoryBag getCategoryBag() {
        return this.categoryBag;
    }

    public void setCategoryBag(CategoryBag categoryBag) {
        this.categoryBag = categoryBag;
    }

    public BusinessKey getBusinessKey() {
        return this.businessKey;
    }

    public void setBusinessKey(BusinessKey businessKey) {
        this.businessKey = businessKey;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public String getAuthorizedName() {
        return this.authorizedName;
    }

    public void setAuthorizedName(String authorizedName) {
        this.authorizedName = authorizedName;
    }

    public synchronized boolean equals(Object obj) {
        if (!(obj instanceof BusinessEntity)) {
            return false;
        }
        BusinessEntity other = (BusinessEntity)obj;
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.__equalsCalc != null) {
            return this.__equalsCalc == obj;
        }
        this.__equalsCalc = obj;
        boolean _equals = (this.discoveryURLs == null && other.getDiscoveryURLs() == null || this.discoveryURLs != null && this.discoveryURLs.equals(other.getDiscoveryURLs())) && (this.name == null && other.getName() == null || this.name != null && Arrays.equals(this.name, other.getName())) && (this.description == null && other.getDescription() == null || this.description != null && Arrays.equals(this.description, other.getDescription())) && (this.contacts == null && other.getContacts() == null || this.contacts != null && this.contacts.equals(other.getContacts())) && (this.businessServices == null && other.getBusinessServices() == null || this.businessServices != null && this.businessServices.equals(other.getBusinessServices())) && (this.identifierBag == null && other.getIdentifierBag() == null || this.identifierBag != null && this.identifierBag.equals(other.getIdentifierBag())) && (this.categoryBag == null && other.getCategoryBag() == null || this.categoryBag != null && this.categoryBag.equals(other.getCategoryBag())) && (this.businessKey == null && other.getBusinessKey() == null || this.businessKey != null && this.businessKey.equals(other.getBusinessKey())) && (this.operator == null && other.getOperator() == null || this.operator != null && this.operator.equals(other.getOperator())) && (this.authorizedName == null && other.getAuthorizedName() == null || this.authorizedName != null && this.authorizedName.equals(other.getAuthorizedName()));
        this.__equalsCalc = null;
        return _equals;
    }

    public synchronized int hashCode() {
        Object obj;
        int i;
        if (this.__hashCodeCalc) {
            return 0;
        }
        this.__hashCodeCalc = true;
        int _hashCode = 1;
        if (this.getDiscoveryURLs() != null) {
            _hashCode += this.getDiscoveryURLs().hashCode();
        }
        if (this.getName() != null) {
            for (i = 0; i < Array.getLength(this.getName()); ++i) {
                obj = Array.get(this.getName(), i);
                if (obj == null || obj.getClass().isArray()) continue;
                _hashCode += obj.hashCode();
            }
        }
        if (this.getDescription() != null) {
            for (i = 0; i < Array.getLength(this.getDescription()); ++i) {
                obj = Array.get(this.getDescription(), i);
                if (obj == null || obj.getClass().isArray()) continue;
                _hashCode += obj.hashCode();
            }
        }
        if (this.getContacts() != null) {
            _hashCode += this.getContacts().hashCode();
        }
        if (this.getBusinessServices() != null) {
            _hashCode += this.getBusinessServices().hashCode();
        }
        if (this.getIdentifierBag() != null) {
            _hashCode += this.getIdentifierBag().hashCode();
        }
        if (this.getCategoryBag() != null) {
            _hashCode += this.getCategoryBag().hashCode();
        }
        if (this.getBusinessKey() != null) {
            _hashCode += this.getBusinessKey().hashCode();
        }
        if (this.getOperator() != null) {
            _hashCode += this.getOperator().hashCode();
        }
        if (this.getAuthorizedName() != null) {
            _hashCode += this.getAuthorizedName().hashCode();
        }
        this.__hashCodeCalc = false;
        return _hashCode;
    }

    public static TypeDesc getTypeDesc() {
        return typeDesc;
    }

    public static Serializer getSerializer(String mechType, Class _javaType, QName _xmlType) {
        return new BeanSerializer(_javaType, _xmlType, typeDesc);
    }

    public static Deserializer getDeserializer(String mechType, Class _javaType, QName _xmlType) {
        return new BeanDeserializer(_javaType, _xmlType, typeDesc);
    }

    public void saveToXML(Element parent) {
        int i;
        this.baseElement = parent.getOwnerDocument().createElement("businessEntity");
        if (this.businessKey != null) {
            this.baseElement.setAttribute("businessKey", this.businessKey.getValue());
        }
        if (this.operator != null) {
            this.baseElement.setAttribute("operator", this.operator);
        }
        if (this.authorizedName != null) {
            this.baseElement.setAttribute("authorizedName", this.authorizedName);
        }
        if (this.discoveryURLs != null) {
            this.discoveryURLs.saveToXML(this.baseElement);
        }
        if (this.name != null && this.name.length > 0) {
            for (i = 0; i < this.name.length; ++i) {
                if (this.name[i] == null) continue;
                this.name[i].saveToXML(this.baseElement);
            }
        }
        if (this.description != null && this.description.length > 0) {
            for (i = 0; i < this.description.length; ++i) {
                if (this.description[i] == null) continue;
                this.description[i].saveToXML(this.baseElement);
            }
        }
        if (this.contacts != null) {
            this.contacts.saveToXML(this.baseElement);
        }
        if (this.businessServices != null) {
            this.businessServices.saveToXML(this.baseElement);
        }
        if (this.identifierBag != null) {
            this.identifierBag.saveToXML(this.baseElement);
        }
        if (this.categoryBag != null) {
            this.categoryBag.saveToXML(this.baseElement);
        }
        parent.appendChild(this.baseElement);
    }

    static {
        typeDesc.setXmlType(new QName("urn:uddi-org:api_v2", "businessEntity"));
        AttributeDesc attrField = new AttributeDesc();
        attrField.setFieldName("businessKey");
        attrField.setXmlName(new QName("", "businessKey"));
        attrField.setXmlType(new QName("urn:uddi-org:api_v2", "businessKey"));
        typeDesc.addFieldDesc((FieldDesc)attrField);
        attrField = new AttributeDesc();
        attrField.setFieldName("operator");
        attrField.setXmlName(new QName("", "operator"));
        attrField.setXmlType(new QName("http://www.w3.org/2001/XMLSchema", "string"));
        typeDesc.addFieldDesc((FieldDesc)attrField);
        attrField = new AttributeDesc();
        attrField.setFieldName("authorizedName");
        attrField.setXmlName(new QName("", "authorizedName"));
        attrField.setXmlType(new QName("http://www.w3.org/2001/XMLSchema", "string"));
        typeDesc.addFieldDesc((FieldDesc)attrField);
        ElementDesc elemField = new ElementDesc();
        elemField.setFieldName("discoveryURLs");
        elemField.setXmlName(new QName("urn:uddi-org:api_v2", "discoveryURLs"));
        elemField.setXmlType(new QName("urn:uddi-org:api_v2", "discoveryURLs"));
        elemField.setMinOccurs(0);
        typeDesc.addFieldDesc((FieldDesc)elemField);
        elemField = new ElementDesc();
        elemField.setFieldName("name");
        elemField.setXmlName(new QName("urn:uddi-org:api_v2", "name"));
        elemField.setXmlType(new QName("urn:uddi-org:api_v2", "name"));
        typeDesc.addFieldDesc((FieldDesc)elemField);
        elemField = new ElementDesc();
        elemField.setFieldName("description");
        elemField.setXmlName(new QName("urn:uddi-org:api_v2", "description"));
        elemField.setXmlType(new QName("urn:uddi-org:api_v2", "description"));
        elemField.setMinOccurs(0);
        typeDesc.addFieldDesc((FieldDesc)elemField);
        elemField = new ElementDesc();
        elemField.setFieldName("contacts");
        elemField.setXmlName(new QName("urn:uddi-org:api_v2", "contacts"));
        elemField.setXmlType(new QName("urn:uddi-org:api_v2", "contacts"));
        elemField.setMinOccurs(0);
        typeDesc.addFieldDesc((FieldDesc)elemField);
        elemField = new ElementDesc();
        elemField.setFieldName("businessServices");
        elemField.setXmlName(new QName("urn:uddi-org:api_v2", "businessServices"));
        elemField.setXmlType(new QName("urn:uddi-org:api_v2", "businessServices"));
        elemField.setMinOccurs(0);
        typeDesc.addFieldDesc((FieldDesc)elemField);
        elemField = new ElementDesc();
        elemField.setFieldName("identifierBag");
        elemField.setXmlName(new QName("urn:uddi-org:api_v2", "identifierBag"));
        elemField.setXmlType(new QName("urn:uddi-org:api_v2", "identifierBag"));
        elemField.setMinOccurs(0);
        typeDesc.addFieldDesc((FieldDesc)elemField);
        elemField = new ElementDesc();
        elemField.setFieldName("categoryBag");
        elemField.setXmlName(new QName("urn:uddi-org:api_v2", "categoryBag"));
        elemField.setXmlType(new QName("urn:uddi-org:api_v2", "categoryBag"));
        elemField.setMinOccurs(0);
        typeDesc.addFieldDesc((FieldDesc)elemField);
    }
}

